/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class KeypadBlock
extends DisguisableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public KeypadBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        KeypadBlockEntity be = (KeypadBlockEntity)world.func_175625_s(pos);
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && be.getSignalLength() > 0) {
            return false;
        }
        if (!world.field_72995_K) {
            if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(world, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(state, world, pos, be.getSignalLength());
                } else if (player.func_184586_b(hand).func_77973_b() != SCContent.codebreaker) {
                    be.openPasscodeGUI(world, pos, player);
                }
            }
        }
        return true;
    }

    public void activate(IBlockState state, World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, state.func_177231_a((IProperty)POWERED));
        BlockUtils.updateIndirectNeighbors(world, pos, SCContent.keypad);
        if (signalLength > 0) {
            world.func_175684_a(pos, (Block)this, signalLength);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.keypad);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            BlockUtils.updateIndirectNeighbors(world, pos, (Block)this);
        }
        if (te instanceof IPasscodeProtected) {
            SaltData.removeSalt(((IPasscodeProtected)te).getSaltKey());
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 15) {
            return this.func_176223_P();
        }
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)POWERED) && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        if (!state.func_177228_b().containsKey((Object)FACING)) {
            return 15;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new KeypadBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public static class Convertible
    implements Function<Object, IPasscodeConvertible>,
    IPasscodeConvertible {
        @Override
        public IPasscodeConvertible apply(Object o) {
            return this;
        }

        @Override
        public boolean isUnprotectedBlock(IBlockState state) {
            return state.func_177230_c() == SCContent.frame;
        }

        @Override
        public boolean isProtectedBlock(IBlockState state) {
            return state.func_177230_c() == SCContent.keypad;
        }

        @Override
        public boolean protect(EntityPlayer player, World world, BlockPos pos) {
            FrameBlockEntity be = (FrameBlockEntity)world.func_175625_s(pos);
            if (be.getCurrentCamera() != null) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.cannotConvert", new Object[0]), TextFormatting.RED);
                return false;
            }
            Owner owner = be.getOwner();
            be.dropAllModules();
            world.func_175656_a(pos, SCContent.keypad.func_176223_P().func_177226_a((IProperty)FACING, world.func_180495_p(pos).func_177229_b((IProperty)FrameBlock.FACING)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }

        @Override
        public boolean unprotect(EntityPlayer player, World world, BlockPos pos) {
            KeypadBlockEntity be = (KeypadBlockEntity)world.func_175625_s(pos);
            Owner owner = be.getOwner();
            be.dropAllModules();
            world.func_175656_a(pos, SCContent.frame.func_176223_P().func_177226_a((IProperty)FrameBlock.FACING, world.func_180495_p(pos).func_177229_b((IProperty)FACING)));
            ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }
    }
}

